﻿# --- 設定 ---
$targetPath = "C:\Program Files\Ericom Software\Ericom Connect Data Grid\Runtime\gslicense.xml"

# 管理者権限での実行確認
Write-Host "***管理者権限での実行確認***"
if (-not(([Security.Principal.WindowsPrincipal] `
    [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole(`
    [Security.Principal.WindowsBuiltInRole] "Administrator"`
    ))) {
    Write-Host "管理者として実行されていません。[Update_GridLicense.bat]から実行してください。" -ForegroundColor Yellow
    Write-Host "終了する場合は何かキーを押してください..." -NoNewLine
    [Console]::ReadKey($true) > $null 2>&1
    exit
}else{
    Write-Host "管理者として実行されています。"
}


Write-Host 
Write-Host


# 新しいライセンス内容
$newContent = @"
<com>
  <j_spaces>
        <kernel>
        	<licensekey>Jul 1, 2027~Ericom Software Ltd._PROD@ZMNS5PXOOSNQSNOtNQRW#PREMIUM^10.0XAPPremium%UNBOUND+UNLIMITED</licensekey>
       </kernel>
  </j_spaces>
</com>
"@

# --- 実行処理 ---
Write-Host "***実行処理***"
try {
    # 1. パスの確認
    if (-not (Test-Path $targetPath)) {
        Write-Error "対象のファイルが見つかりません: $targetPath"
        # exit ではなく、catchブロックへ飛ばすか、ここで終了処理に入る
    }
    else {
        # 2. バックアップの作成 (gslicense.xml.yyyymmddhhmmss.bak)
        # 現在日時を取得 (例: 20260204120000)
        $timestamp = Get-Date -Format "yyyyMMddHHmmss"
        $backupPath = "$targetPath.$timestamp.bak"

        Copy-Item -Path $targetPath -Destination $backupPath -Force
        Write-Host "バックアップを作成しました: $backupPath" -ForegroundColor Cyan

        # 3. 新しいライセンス内容の書き込み（UTF8エンコーディング）
        [System.IO.File]::WriteAllText($targetPath, $newContent, [System.Text.Encoding]::UTF8)
        Write-Host "ライセンスファイルを更新しました。" -ForegroundColor Green

        # 4. 完了メッセージ
        Write-Host "`n重要: 設定を反映させるため、OSもしくはEricomConnectサービスを再起動してください。" -ForegroundColor Yellow
    }

} catch {
    Write-Error "エラーが発生しました: $_"
}